//
//  MCTrashableObjectProtocol.h
//  MCFoundation
//
//  Created by Ali Lalani on 30/05/07.
//  Copyright 2007 Marketcircle Inc.. All rights reserved.
//

#import <Foundation/Foundation.h>

@class BDQualifier;

@protocol MCTrashableObject <NSObject>
+ (BDQualifier *)ownedOrDelegatedToQualfierForUser:(id)aUser;

+ (BOOL)isTrashable;
- (BOOL)isTrashable;
- (BOOL)isTrashed;

// Before the object is trashed
- (void)willMarkForTrash;
- (void)didMarkForTrash;

// Once the object is in the trash
- (void)willRestoreFromTrash;
- (void)didRestoreFromTrash;

- (NSNumber *)deletionUserID;
- (void)setDeletionUserID:(NSNumber *)aDeletionUserID;
- (NSString *)deletionIdentifier;
- (void)setDeletionIdentifier:(NSString *)aDeletionIdentifier;
- (NSCalendarDate *)deletionDate;
- (void)setDeletionDate:(NSCalendarDate *)aDeletionDate;

@end
